import math
import triangulo

def distancia(x1, y1, x2, y2):
	"""
	distancia: num num num num -> float
	calcula la distancia entre puntos (x1, y1) y (x2, y2)
	ejemplo: 
	distancia(-2, 1, 1, 5) = 5
	distancia(-2, -3, -4, 4) = 7.28
	"""
	d2 = (x2 - x1) ** 2 + (y2 - y1) ** 2
	return math.sqrt(d2)

#test
#print distancia(-2, 1, 1, 5), "= 5"
#print distancia(-2, -3, -4, 4), "= 7.28"

def area_puntos(x1, y1, x2, y2, x3, y3):
	"""
	area_puntos: num num num num num num -> float
	calcula la area de un triangulo con sus coordinades
	ejemplo:
	area_puntos(0,0,1,0,1,1) = 0.5
	"""
	lado_a = distancia(x1, y1, x2, y2)
	lado_b = distancia(x2, y2, x3, y3)
	lado_c = distancia(x3, y3, x1, y1)
	return triangulo.area(lado_a, lado_b, lado_c)

#test
#print area_puntos(0,0,1,0,1,1), "= 0.5"


x1 = input("x1? ")
y1 = input("y1? ")
x2 = input("x2? ")
y2 = input("y2? ")
x3 = input("x3? ")
y3 = input("y3? ")

area_puntos(x1, y1, x2, y2, x3, y3)


